﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_RespondentIncDecQuotaIdList]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_RespondentIncDecQuotaIdList]
GO

CREATE PROCEDURE [dbo].[sp_RespondentIncDecQuotaIdList] 
	@projectId int, 
	@userId int,
	@completedSynchedRespondents AS [dbo].[RespondentsIdList] READONLY,
    @operation bit
AS
BEGIN
	DECLARE  @CNT INT
	IF @operation = 1
	SET @CNT = 1
	ELSE
	SET @CNT = -1

	UPDATE Quota 
    SET QtFrequence = QtFrequence + StrFrequence,
		FrequencyForThePeriod = FrequencyForThePeriod + StrFrequencyForThePeriod
	FROM Quota
    INNER JOIN (
	    SELECT 
		    StrQuotaId, 
		    SUM (CASE 
					WHEN Quota.ValidityPeriod > 0 AND  Respondent.ResCompletedDate > Quota.GlobalPeriodStartDate THEN @CNT*COALESCE(IncrementValue,1)
					WHEN Quota.ValidityPeriod = 0 THEN @CNT*COALESCE(IncrementValue,1) 
				 ELSE 
					0 
				 END) AS StrFrequence,
		    SUM (CASE 
					WHEN Quota.ValidityPeriod > 0 AND  Respondent.ResCompletedDate > Quota.BreakdownPeriodStartDate THEN @CNT*COALESCE(IncrementValue,1) 
				 ELSE 
					0 
				 END) AS StrFrequencyForThePeriod
		FROM Quota WITH(nolock)
		INNER JOIN Stratum WITH(nolock) ON QtQuotaId = StrQuotaId
		INNER JOIN Respondent WITH(nolock) on ResRespondent = StrRespondent 
		INNER JOIN @completedSynchedRespondents sr on sr.Id = ResRespondent
		WHERE IncrementValue <> 0
		GROUP BY StrQuotaId
	) AS s
	ON QtQuotaId = StrQuotaId
	WHERE QtStratum > 0

	DECLARE @completedSynchedRespondentsCount int
	SELECT @completedSynchedRespondentsCount = COUNT(*) FROM @completedSynchedRespondents

	--Update Master Quota frequency
	UPDATE Quota
	SET QtFrequence = QtFrequence + @CNT * @completedSynchedRespondentsCount
	WHERE QtStratum = 0

	UPDATE QuotasAgent
	SET Frequency= Frequency + StrFrequency
	FROM QuotasAgent
	INNER JOIN (
		SELECT StrQuotaId, SUM(@CNT*COALESCE(IncrementValue,1)) AS StrFrequency
		FROM  @completedSynchedRespondents sr
		INNER JOIN Stratum WITH(NOLOCK) ON sr.Id = StrRespondent
		GROUP BY StrQuotaId 
	) AS s
	ON QuotaId = StrQuotaId AND AgentId = @userId

	IF @CNT = 1
	BEGIN
	  -- Define if quotas are active
	  DECLARE @UseQuotas BIT
	  SET @UseQuotas = (SELECT TOP 1 insvalue FROM installation WHERE inssection = 'QUOTAS' AND insident = 'QUOTASACTIFS')
	  IF @UseQuotas IS NULL SET @UseQuotas = 0

	  -- Check if quota tracking by period is enabled
	  DECLARE @UseQuotasTrackingByPeriod BIT
	  SET @UseQuotasTrackingByPeriod = (SELECT TOP 1 insvalue FROM installation WHERE inssection = 'QUOTAS' AND insident = 'ENABLE_TRACKING_BY_PERIOD')
	  IF @UseQuotasTrackingByPeriod IS NULL SET @UseQuotasTrackingByPeriod = 0

	  IF @UseQuotas = 1
	  BEGIN
		DECLARE @NonClosedStrata INT

		SELECT DISTINCT(StrQuotaId)
		INTO #closingstrata
		FROM @completedSynchedRespondents csr
		INNER JOIN Stratum ON csr.Id = StrRespondent
		INNER JOIN Quota ON QtQuotaId = StrQuotaId
			AND QtQuota > 0
			AND (QtFrequence >= QtQuota OR
				((@UseQuotasTrackingByPeriod = 1) AND (QuotaForThePeriod > 0) AND (FrequencyForThePeriod >= QuotaForThePeriod)))
			AND qtstatus <> 2
		WHERE  StrStratum > 0

	    -- Count the number of strata to close
		SELECT @NonClosedStrata = Count(StrQuotaId) FROM #closingstrata

		IF @NonClosedStrata > 0
		BEGIN
		  -- Call sp_UpdateStrataState, which will close strata that are full and set as half opened strata that might be full if all online interviews become completed
		  EXEC sp_UpdateStrataState  @projectId, @userId

		  -- Block respondents belonging to a closed stratum
		  UPDATE respondent
		  SET    resblocked = 1,
				 projectid = @projectId,
				 modifiedby = @userId,
				 modified = Getutcdate()
		  WHERE  resrespondent IN
								 (SELECT strrespondent
								  FROM   stratum
								  WHERE  StrQuotaId IN (SELECT StrQuotaId FROM #closingstrata))
		END -- if @NonClosedStrata > 0
	  END -- if @UseQuotas = 1
	END -- if CNT = 1
END
GO
